/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.gui.util;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.util.text.TextComponentTranslation;
import noppes.npcs.LogWriter;
import noppes.npcs.api.mixin.client.gui.IGuiTextFieldMixin;
import noppes.npcs.client.gui.util.GuiNpcTextArea;
import noppes.npcs.client.gui.util.IComponentGui;
import noppes.npcs.client.gui.util.IEditNPC;
import noppes.npcs.client.gui.util.IGuiNpcTextField;
import noppes.npcs.client.gui.util.ITextfieldListener;
import noppes.npcs.util.ValueUtil;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

public class GuiNpcTextField
extends GuiTextField
implements IComponentGui,
IGuiNpcTextField {
    public static char[] filePath = new char[]{':', '*', '?', '\"', '<', '>', '&', '|'};
    public static IGuiNpcTextField activeTextfield = null;
    private final List<String> hoverText = new ArrayList<String>();
    private final int[] allowedSpecialKeyIDs = new int[]{14, 211, 203, 205};
    public char[] prohibitedSpecialChars = new char[0];
    public boolean enabled = true;
    public boolean hovered;
    protected boolean canEdit = true;
    private boolean latinAlphabetOnly = false;
    private boolean allowUppercase = true;
    private boolean numbersOnly = false;
    private boolean doubleNumbersOnly = false;
    private ITextfieldListener listener;
    public long min = Integer.MIN_VALUE;
    public long max = Integer.MAX_VALUE;
    public long def = 0L;
    public double minD = Double.MIN_VALUE;
    public double maxD = Double.MAX_VALUE;
    public double defD = 0.0;

    public static boolean isActive() {
        return activeTextfield != null;
    }

    public static void unfocus() {
        IGuiNpcTextField prev = activeTextfield;
        activeTextfield = null;
        if (prev != null) {
            prev.unFocus();
        }
    }

    public GuiNpcTextField(int id, GuiScreen parent, FontRenderer fontRenderer, int x, int y, int width, int height, String text) {
        super(id, fontRenderer, x, y, width, height);
        this.func_146203_f(500);
        this.setFullText(text == null ? "" : text);
        if (parent instanceof ITextfieldListener) {
            this.listener = (ITextfieldListener)parent;
        }
    }

    public GuiNpcTextField(int id, GuiScreen parent, int x, int y, int width, int height, String text) {
        this(id, parent, Minecraft.func_71410_x().field_71466_p, x, y, width, height, text);
    }

    private boolean charAllowed(char c, int i) {
        for (char g : this.prohibitedSpecialChars) {
            if (g != c) continue;
            return false;
        }
        for (int j : this.allowedSpecialKeyIDs) {
            if (j != i) continue;
            return true;
        }
        boolean bl = this.func_146207_c().equals(this.getFullText());
        if (this.numbersOnly) {
            return Character.isDigit(c) || c == '-' && bl || this.func_146198_h() == 0 && !this.getFullText().contains("" + c);
        }
        if (this.doubleNumbersOnly) {
            boolean hasDot = this.getFullText().contains(".") || this.getFullText().contains(",");
            return Character.isDigit(c) || c == '-' && bl || this.func_146198_h() == 0 && !this.getFullText().contains("" + c) || !hasDot || bl && (c == '.' || c == ',');
        }
        if (!this.latinAlphabetOnly || Character.isLetterOrDigit(c) || c == '_') {
            return true;
        }
        return this.allowUppercase || Character.isLowerCase(c);
    }

    public void func_146194_f() {
        if (!this.enabled) {
            return;
        }
        super.func_146194_f();
    }

    @Override
    public void render(IEditNPC gui, int mouseX, int mouseY, float partialTicks) {
        int dWheel;
        boolean bl = this.hovered = mouseX >= this.field_146209_f && mouseY >= this.field_146210_g && mouseX < this.field_146209_f + this.field_146218_h && mouseY < this.field_146210_g + this.field_146219_i;
        if (this.hovered && !gui.hasSubGui() && !this.hoverText.isEmpty()) {
            gui.setHoverText(this.hoverText);
        }
        if (this.hovered && (this.doubleNumbersOnly || this.numbersOnly) && (dWheel = Mouse.getDWheel()) != 0) {
            if (this.doubleNumbersOnly) {
                double d = this.getDouble();
                double v = this.maxD - this.minD;
                double f = (dWheel < 0 ? -v : v) / (double)this.field_146218_h;
                double t = d + f;
                if (t < this.minD) {
                    t = t - this.minD + this.maxD;
                } else if (t > this.maxD) {
                    t = t - this.maxD + this.minD;
                }
                this.setFullText("" + ValueUtil.correctDouble((double)Math.round(t * 1000.0) / 1000.0, this.minD, this.maxD));
            } else {
                int i = this.getInteger();
                int v = (int)(this.max - this.min);
                int f = (dWheel < 0 ? -v : v) / this.field_146218_h;
                int t = i + f;
                if ((long)t < this.min) {
                    t -= (int)(this.min + this.max);
                } else if ((long)t > this.max) {
                    t -= (int)(this.max + this.min);
                }
                this.setFullText("" + ValueUtil.correctInt((int)((double)Math.round((double)t * 1000.0) / 1000.0), (int)this.min, (int)this.max));
            }
            if (this.listener != null) {
                this.listener.unFocused(this);
            }
        }
        this.func_146194_f();
    }

    @Override
    public int getID() {
        return this.func_175206_d();
    }

    @Override
    public double getDouble() {
        double d = this.defD;
        try {
            d = Double.parseDouble(this.getFullText().replace(",", "."));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return d;
    }

    @Override
    public int getInteger() {
        int i = (int)this.def;
        try {
            i = Integer.parseInt(this.getFullText());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return i;
    }

    @Override
    public long getLong() {
        long i = 0L;
        try {
            i = Long.parseLong(this.getFullText());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return i;
    }

    @Override
    public boolean isDouble() {
        try {
            Double.parseDouble(this.getFullText().replace(",", "."));
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    @Override
    public boolean isEmpty() {
        return this.getFullText().trim().isEmpty();
    }

    @Override
    public long getDefault() {
        return this.def;
    }

    @Override
    public double getDoubleDefault() {
        return this.defD;
    }

    @Override
    public boolean isInteger() {
        try {
            Integer.parseInt(this.getFullText());
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    @Override
    public boolean isLong() {
        try {
            Long.parseLong(this.getFullText());
            return true;
        }
        catch (NumberFormatException e) {
            LogWriter.error(e);
            return false;
        }
    }

    @Override
    public boolean isHovered() {
        return this.hovered;
    }

    public boolean func_146192_a(int mouseX, int mouseY, int mouseButton) {
        if (!this.canEdit) {
            return false;
        }
        boolean isFocused = this.func_146206_l();
        if (((IGuiTextFieldMixin)((Object)this)).npcs$getCanLoseFocus()) {
            this.setFocus(this.hovered);
        }
        if (isFocused && this.hovered && mouseButton == 0) {
            int i = mouseX - this.field_146209_f;
            if (((IGuiTextFieldMixin)((Object)this)).npcs$getEnableBackgroundDrawing()) {
                i -= 4;
            }
            FontRenderer fontRenderer = ((IGuiTextFieldMixin)((Object)this)).npcs$getFontRenderer();
            int lineScrollOffset = ((IGuiTextFieldMixin)((Object)this)).npcs$getLineScrollOffset();
            String s = fontRenderer.func_78269_a(this.getFullText().substring(lineScrollOffset), this.func_146200_o());
            this.func_146190_e(fontRenderer.func_78269_a(s, i).length() + lineScrollOffset);
            return true;
        }
        if (isFocused != this.func_146206_l() && isFocused) {
            this.unFocus();
        }
        if (this.func_146206_l()) {
            activeTextfield = this;
        }
        return false;
    }

    @Override
    public boolean isVisible() {
        return this.func_146176_q();
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setMinMaxDefault(long minValue, long maxValue, long defaultValue) {
        this.numbersOnly = true;
        this.doubleNumbersOnly = false;
        if (minValue > maxValue) {
            long i = minValue;
            minValue = maxValue;
            maxValue = i;
        }
        this.min = minValue;
        this.max = maxValue;
        this.def = defaultValue;
    }

    @Override
    public void setMinMaxDoubleDefault(double minValue, double maxValue, double defaultValue) {
        this.numbersOnly = false;
        this.doubleNumbersOnly = true;
        if (minValue > maxValue) {
            double i = minValue;
            minValue = maxValue;
            maxValue = i;
        }
        this.minD = minValue;
        this.maxD = maxValue;
        this.defD = defaultValue;
    }

    @Override
    public boolean isAllowUppercase() {
        return this.allowUppercase;
    }

    @Override
    public void setAllowUppercase(boolean isAllowUppercase) {
        this.allowUppercase = isAllowUppercase;
    }

    @Override
    public long getMax() {
        return this.max;
    }

    @Override
    public long getMin() {
        return this.min;
    }

    @Override
    public double getDoubleMax() {
        return this.maxD;
    }

    @Override
    public double getDoubleMin() {
        return this.minD;
    }

    @Override
    public boolean isLatinAlphabetOnly() {
        return this.latinAlphabetOnly;
    }

    @Override
    public void setLatinAlphabetOnly(boolean isLatinAlphabetOnly) {
        this.latinAlphabetOnly = isLatinAlphabetOnly;
    }

    public boolean func_146201_a(char typedChar, int keyCode) {
        if (!this.func_146206_l()) {
            return false;
        }
        if (keyCode == 28 && !(this instanceof GuiNpcTextArea) && this.listener != null) {
            this.listener.unFocused(this);
            return false;
        }
        if (this.latinAlphabetOnly && typedChar == ' ') {
            typedChar = (char)95;
        }
        if (Keyboard.getKeyName((int)keyCode).startsWith("NUMPAD")) {
            typedChar = Keyboard.getKeyName((int)keyCode).replace("NUMPAD", "").charAt(0);
        }
        if (GuiScreen.func_175278_g((int)keyCode)) {
            this.func_146202_e();
            this.func_146199_i(0);
            return true;
        }
        if (GuiScreen.func_175280_f((int)keyCode)) {
            GuiScreen.func_146275_d((String)this.func_146207_c());
            return true;
        }
        if (GuiScreen.func_175279_e((int)keyCode) && this.canEdit) {
            if (this.isEnabled()) {
                this.func_146191_b(GuiScreen.func_146277_j());
            }
            return true;
        }
        if (GuiScreen.func_175277_d((int)keyCode)) {
            GuiScreen.func_146275_d((String)this.func_146207_c());
            if (this.canEdit && this.isEnabled()) {
                this.func_146191_b("");
            }
            return true;
        }
        if (!this.canEdit) {
            return false;
        }
        switch (keyCode) {
            case 14: {
                if (GuiScreen.func_146271_m()) {
                    if (this.isEnabled()) {
                        this.func_146177_a(-1);
                    }
                } else if (this.isEnabled()) {
                    this.func_146175_b(-1);
                }
                return true;
            }
            case 199: {
                if (GuiScreen.func_146272_n()) {
                    this.func_146199_i(0);
                } else {
                    this.func_146196_d();
                }
                return true;
            }
            case 203: {
                if (GuiScreen.func_146272_n()) {
                    if (GuiScreen.func_146271_m()) {
                        this.func_146199_i(this.func_146183_a(-1, this.func_146186_n()));
                    } else {
                        this.func_146199_i(this.func_146186_n() - 1);
                    }
                } else if (GuiScreen.func_146271_m()) {
                    this.func_146190_e(this.func_146187_c(-1));
                } else {
                    this.func_146182_d(-1);
                }
                return true;
            }
            case 205: {
                if (GuiScreen.func_146272_n()) {
                    if (GuiScreen.func_146271_m()) {
                        this.func_146199_i(this.func_146183_a(1, this.func_146186_n()));
                    } else {
                        this.func_146199_i(this.func_146186_n() + 1);
                    }
                } else if (GuiScreen.func_146271_m()) {
                    this.func_146190_e(this.func_146187_c(1));
                } else {
                    this.func_146182_d(1);
                }
                return true;
            }
            case 207: {
                if (GuiScreen.func_146272_n()) {
                    this.func_146199_i(this.getFullText().length());
                } else {
                    this.func_146202_e();
                }
                return true;
            }
            case 211: {
                if (GuiScreen.func_146271_m()) {
                    if (this.isEnabled()) {
                        this.func_146177_a(1);
                    }
                } else if (this.isEnabled()) {
                    this.func_146175_b(1);
                }
                return true;
            }
        }
        if (this.charAllowed(typedChar, keyCode)) {
            if (this.isEnabled()) {
                this.func_146191_b(Character.toString(typedChar));
            }
            return true;
        }
        return false;
    }

    @Override
    public void setFocus(boolean bo) {
        this.func_146195_b(bo);
    }

    @Override
    public String getFullText() {
        return this.func_146179_b();
    }

    @Override
    public void setFullText(String text) {
        this.func_146180_a(text);
    }

    @Override
    public void unFocus() {
        if (this.numbersOnly) {
            if (this.isEmpty() || !this.isInteger()) {
                this.setFullText(this.def + "");
            } else if ((long)this.getInteger() < this.min) {
                this.setFullText(this.min + "");
            } else if ((long)this.getInteger() > this.max) {
                this.setFullText(this.max + "");
            }
        } else if (this.doubleNumbersOnly) {
            if (this.isEmpty() || !this.isDouble()) {
                this.setFullText(this.defD + "");
            } else if (this.getDouble() < this.minD) {
                this.setFullText(this.minD + "");
            } else if (this.getDouble() > this.maxD) {
                this.setFullText(this.maxD + "");
            }
        }
        if (this.listener != null) {
            this.listener.unFocused(this);
        }
        if (this == activeTextfield) {
            activeTextfield = null;
        }
        this.setFocus(false);
    }

    @Override
    public int[] getCenter() {
        return new int[]{this.field_146209_f + this.field_146218_h / 2, this.field_146210_g + this.field_146219_i / 2};
    }

    @Override
    public void setHoverText(String text, Object ... args) {
        this.hoverText.clear();
        if (text == null || text.isEmpty()) {
            return;
        }
        if (!text.contains("%")) {
            text = new TextComponentTranslation(text, args).func_150254_d();
        }
        if (text.contains("~~~")) {
            text = text.replaceAll("~~~", "%");
        }
        while (text.contains("<br>")) {
            this.hoverText.add(text.substring(0, text.indexOf("<br>")));
            text = text.substring(text.indexOf("<br>") + 4);
        }
        this.hoverText.add(text);
    }

    @Override
    public int getLeft() {
        return this.field_146209_f;
    }

    @Override
    public int getTop() {
        return this.field_146210_g;
    }

    @Override
    public void setLeft(int left) {
        this.field_146209_f = left;
    }

    @Override
    public void setTop(int top) {
        this.field_146210_g = top;
    }

    @Override
    public int getHeight() {
        return this.field_146219_i;
    }

    @Override
    public void customKeyTyped(char c, int id) {
        this.func_146201_a(c, id);
    }

    @Override
    public void customMouseClicked(int mouseX, int mouseY, int mouseButton) {
        this.func_146192_a(mouseX, mouseY, mouseButton);
    }

    @Override
    public void customMouseReleased(int mouseX, int mouseY, int mouseButton) {
    }

    @Override
    public void setIsVisible(boolean bo) {
        super.func_146189_e(bo);
    }

    public void updateScreen() {
        if (this.enabled) {
            this.func_146178_a();
        }
    }
}

